package org.msh.tb.bd.tbforms.query.tb12;

import org.msh.tb.entities.enums.PatientType;

/**
 * Created by Mauricio Santos on 20/04/2017.
 */
public enum TB12Row {
    NEW_UNKNOWN("manag.tbform12.row1", "EASho5QgnUs", "Oll7U8NqQa0"),
    RELAPSES("PatientType.RELAPSE", "qtnsJRgTc7t", "GoNd713wiz5"),
    AFTER_FAILURE("PatientType.TREATMENT_AFTER_FAILURE", "d5CJlU5rGy8", "cLC9Vy4xeci"),
    AFTER_LOSS_FOLLOWUP("PatientType.TREATMENT_AFTER_LOSS_FOLLOW_UP", "xI3pK7ga2Rs", "IdqY47uTGqd"),
    OTHERS_PREV_TREAT("PatientType.OTHER_PREVIOUSLY_TREATED", "PWykkWAD6a0", "OqNLm8MiXbn"),
    TOTAL("global.total", null, null);

    String key;

    // DHIS2 Data elements id
    // check in DHIS2: /api/dataSets/pgGUKl6VOBJ?fields=id,displayName,dataElements[id,code,name]
    String table1DataElementId;
    String table2DataElementId;

    TB12Row(String k, String table1DataElementId, String table2DataElementId){
        this.key = k;
        this.table1DataElementId = table1DataElementId;
        this.table2DataElementId = table2DataElementId;
    }

    public String getKey(){
        return key;
    }

    public String getTable1DataElementId() {
        return table1DataElementId;
    }

    public String getTable2DataElementId() {
        return table2DataElementId;
    }

    /**
     * This method will return the TB12Row enum equivalent to the Patient Type passed as parameter
     * @param patientType Patient Type tested
     * @return the TB12Row correspondent to the patient type passed as parameter.
     */
    public static TB12Row getPatientTypeAsRow(PatientType patientType){
        if (patientType == null) {
            throw new RuntimeException("PatientType can't be null");
        }

        switch (patientType) {
            case UNKNOWN_PREVIOUS_TB_TREAT:
            case NEW:
                return TB12Row.NEW_UNKNOWN;
            case RELAPSE:
                return TB12Row.RELAPSES;
            case TREATMENT_AFTER_FAILURE:
                return TB12Row.AFTER_FAILURE;
            case TREATMENT_AFTER_LOSS_FOLLOW_UP:
                return TB12Row.AFTER_LOSS_FOLLOWUP;
            case OTHER_PREVIOUSLY_TREATED:
                return TB12Row.OTHERS_PREV_TREAT;
        }

        throw new RuntimeException("PatientType not valid");
    }
}
